const express = require("express");
const { v4: uuidv4 } = require("uuid");
const File = require("../models/File");
const upload = require("../middleware/uploadMiddleware");
const auth = require("../middleware/authMiddleware");
const path = require("path");
const fs = require("fs");

const router = express.Router();

// Upload file
router.post("/upload", auth, upload.single("file"), async (req, res) => {
  try {
    const file = await File.create({
      filename: req.file.filename,
      originalName: req.file.originalname,
      path: req.file.path,
      size: req.file.size,
      uuid: uuidv4(),
      expiresAt: new Date(Date.now() + 10 * 60 * 1000), // 10 mins expiry
      uploadedBy: req.user.userId,
    });

    const downloadLink = `${req.protocol}://${req.get("host")}/api/file/${file.uuid}`;
    res.json({ message: "File uploaded", downloadLink });
  } catch (err) {
    res.status(500).json({ message: "File upload failed" });
  }
});

// Download file
router.get("/:uuid", async (req, res) => {
  try {
    const file = await File.findOne({ uuid: req.params.uuid });
    if (!file) return res.status(404).json({ message: "File not found or expired" });

    if (new Date() > file.expiresAt) {
      fs.unlinkSync(file.path);
      await file.deleteOne();
      return res.status(410).json({ message: "Link expired" });
    }

    res.download(file.path, file.originalName);
  } catch (err) {
    res.status(500).json({ message: "Download failed" });
  }
});

module.exports = router;
